/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.slot;

import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.holder.slot.ConfigInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHolder;
import mekanism.common.capabilities.holder.slot.ReadOnlyInventorySlotHolder;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.core.Direction;

public class InventorySlotHelper {
    private final IInventorySlotHolder slotHolder;
    private boolean built;

    private InventorySlotHelper(IInventorySlotHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static InventorySlotHelper readOnly() {
        return new InventorySlotHelper(new ReadOnlyInventorySlotHolder());
    }

    public static InventorySlotHelper forSide(Supplier<Direction> facingSupplier) {
        return InventorySlotHelper.forSide(facingSupplier, null, null);
    }

    public static InventorySlotHelper forSide(Supplier<Direction> facingSupplier, @Nullable Predicate<RelativeSide> insertPredicate, @Nullable Predicate<RelativeSide> extractPredicate) {
        return new InventorySlotHelper(new InventorySlotHolder(facingSupplier, insertPredicate, extractPredicate));
    }

    public static InventorySlotHelper forSideWithConfig(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        return new InventorySlotHelper(new ConfigInventorySlotHolder(facingSupplier, configSupplier));
    }

    public <SLOT extends IInventorySlot> SLOT addSlot(@Nonnull SLOT slot) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IInventorySlotHolder iInventorySlotHolder = this.slotHolder;
        if (iInventorySlotHolder instanceof InventorySlotHolder) {
            InventorySlotHolder slotHolder = (InventorySlotHolder)iInventorySlotHolder;
            slotHolder.addSlot(slot, new RelativeSide[0]);
        } else {
            iInventorySlotHolder = this.slotHolder;
            if (iInventorySlotHolder instanceof ReadOnlyInventorySlotHolder) {
                ReadOnlyInventorySlotHolder slotHolder = (ReadOnlyInventorySlotHolder)iInventorySlotHolder;
                slotHolder.addSlot(slot);
            } else {
                iInventorySlotHolder = this.slotHolder;
                if (iInventorySlotHolder instanceof ConfigInventorySlotHolder) {
                    ConfigInventorySlotHolder slotHolder = (ConfigInventorySlotHolder)iInventorySlotHolder;
                    slotHolder.addSlot(slot);
                } else {
                    throw new IllegalArgumentException("Holder does not know how to add slots");
                }
            }
        }
        return slot;
    }

    public <SLOT extends IInventorySlot> SLOT addSlot(@Nonnull SLOT slot, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IInventorySlotHolder iInventorySlotHolder = this.slotHolder;
        if (!(iInventorySlotHolder instanceof InventorySlotHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add slots on specific sides");
        }
        InventorySlotHolder slotHolder = (InventorySlotHolder)iInventorySlotHolder;
        slotHolder.addSlot(slot, sides);
        return slot;
    }

    public IInventorySlotHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

